/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.launching.server;

import com.aptana.core.logging.IdeLog;
import com.aptana.php.debug.core.server.PHPServersManager;
import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.php.debug.ui.launching.PathMappingUpdater;
import com.aptana.php.debug.ui.pathmapper.PathMapperDialog;
import com.aptana.ui.IPropertyDialog;
import com.aptana.ui.PropertyDialogsRegistry;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.util.SWTUtils;
import com.aptana.ui.util.UIUtils;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.ui.internal.ExternalWebServerPropertyDialog;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org2.eclipse.php.debug.core.debugger.pathmapper.PathMapper;
import org2.eclipse.php.internal.core.util.ElementCreationProxy;
import org2.eclipse.php.internal.core.util.ScrolledCompositeImpl;
import org2.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org2.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org2.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org2.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org2.eclipse.php.internal.debug.ui.IDebugServerConnectionTest;
import org2.eclipse.php.internal.debug.ui.launching.LaunchUtilities;
import org2.eclipse.php.internal.debug.ui.launching.server.PHPServerUIMessages;
import org2.eclipse.php.internal.debug.ui.launching.server.ServersPluginImages;
import org2.eclipse.php.util.SWTUtil;

public class ServerLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected IFile selectedFile = null;
    protected Text fFile;
    protected Label fURLLabel;
    protected Text fURLHost;
    protected Text fURLPath;
    protected Button projectButton;
    protected Button fileButton;
    protected Button publish;
    protected Button createNewServer;
    protected Button configureServers;
    protected Button mapPaths;
    protected Button breakOnFirstLine;
    protected Button autoGeneratedURL;
    protected CLabel pathMapperNotification;
    protected Button validateDebuggerBtn;
    protected String[] serverTypeIds;
    protected Combo fDebuggersCombo;
    protected Combo serverCombo;
    protected IServer server;
    protected boolean serverCanPublish = false;
    protected List<IServer> servers;
    protected boolean init = true;
    private static final String READ_ONLY = "read-only";
    protected WidgetListener fListener = new WidgetListener();
    private boolean saveWorkingCopy;
    private Set<String> fDebuggerIds;
    private IDebugServerConnectionTest[] debugTesters = new IDebugServerConnectionTest[0];
    private ILaunchConfiguration workingCopy;

    public void createControl(Composite parent) {
        ScrolledCompositeImpl scrolledComposite = new ScrolledCompositeImpl(parent, 512);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createServerControl(composite);
        this.createFileComponent(composite);
        this.createBreakControl(composite);
        this.createURLControl(composite);
        this.createExtensionControls(composite);
        Dialog.applyDialogFont((Control)composite);
        scrolledComposite.setContent((Control)composite);
        Point size = composite.computeSize(-1, -1);
        scrolledComposite.setMinSize(size.x, size.y);
        this.setControl((Control)scrolledComposite);
    }

    public void createExtensionControls(Composite composite) {
    }

    public void createURLControl(Composite composite) {
        Group group = new Group(composite, 0);
        String projectLabel = PHPServerUIMessages.getString("ServerTab.url");
        group.setText(projectLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.autoGeneratedURL = new Button((Composite)group, 32);
        this.autoGeneratedURL.setText(PHPServerUIMessages.getString("ServerTab.autoGenerate"));
        this.autoGeneratedURL.setSelection(true);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.autoGeneratedURL.setLayoutData((Object)gridData);
        this.autoGeneratedURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerLaunchConfigurationTab.this.initializeURLControl();
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite urlComposite = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        urlComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        urlComposite.setLayoutData((Object)gridData);
        this.fURLLabel = new Label(urlComposite, 0);
        this.fURLLabel.setText(PHPServerUIMessages.getString("ServerTab.urlLabel"));
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 1;
        this.fURLLabel.setLayoutData((Object)gridData);
        this.fURLHost = new Text(urlComposite, 2052);
        gridData = new GridData(768);
        this.fURLHost.setLayoutData((Object)gridData);
        this.fURLHost.setEnabled(false);
        this.fURLPath = new Text(urlComposite, 2052);
        gridData = new GridData(768);
        this.fURLPath.setLayoutData((Object)gridData);
        this.fURLPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(urlComposite, 0);
        this.pathMapperNotification = new CLabel(urlComposite, 16448);
        Display standardDisplay = SWTUtil.getStandardDisplay();
        if (standardDisplay != null) {
            this.pathMapperNotification.setForeground(standardDisplay.getSystemColor(4));
        }
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.pathMapperNotification.setLayoutData((Object)gridData);
    }

    protected void createServerSelectionControl(Composite parent) {
        Font font = parent.getFont();
        GridData data = new GridData(256);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        Group group = new Group(composite, 0);
        group.setText(PHPServerUIMessages.getString("ServerTab.server"));
        GridLayout ly = new GridLayout();
        ly.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)ly);
        group.setLayoutData((Object)gridData);
        Composite debuggerServerComp = new Composite((Composite)group, 0);
        layout = new GridLayout(2, false);
        debuggerServerComp.setLayout((Layout)layout);
        debuggerServerComp.setFont(font);
        Label label = new Label(debuggerServerComp, 64);
        data = new GridData(1);
        data.widthHint = 100;
        label.setLayoutData((Object)data);
        label.setFont(font);
        label.setText("Server Debugger:");
        this.fDebuggersCombo = new Combo(debuggerServerComp, 12);
        this.fDebuggersCombo.setFont(font);
        data = new GridData(768);
        data.widthHint = 100;
        this.fDebuggersCombo.setLayoutData((Object)data);
        this.fDebuggersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                ServerLaunchConfigurationTab.this.updateDebugServerTesters();
            }
        });
        Composite phpServerComp = new Composite((Composite)group, 0);
        layout = new GridLayout(6, false);
        phpServerComp.setLayout((Layout)layout);
        data = new GridData(768);
        phpServerComp.setLayoutData((Object)data);
        phpServerComp.setFont(font);
        label = new Label(phpServerComp, 64);
        data = new GridData(1);
        data.widthHint = 100;
        label.setLayoutData((Object)data);
        label.setFont(font);
        label.setText("PHP Server:");
        this.serverCombo = new Combo(phpServerComp, 2060);
        data = new GridData(768);
        data.widthHint = 250;
        this.serverCombo.setLayoutData((Object)data);
        this.serverCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerLaunchConfigurationTab.this.handleServerSelection();
            }
        });
        this.createNewServer = this.createPushButton(phpServerComp, null, SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)"/icons/add.gif"));
        this.createNewServer.setToolTipText(PHPServerUIMessages.getString("ServerTab.new"));
        this.createNewServer.addSelectionListener((SelectionListener)this.fListener);
        Object gd = this.createNewServer.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = -1;
        }
        this.configureServers = this.createPushButton(phpServerComp, null, ServersPluginImages.get("com.aptana.php.debug.epl.configure.gif"));
        this.configureServers.setToolTipText(PHPServerUIMessages.getString("ServerTab.configure"));
        this.configureServers.addSelectionListener((SelectionListener)this.fListener);
        gd = this.configureServers.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = -1;
        }
        this.mapPaths = this.createPushButton(phpServerComp, null, ServersPluginImages.get("com.aptana.php.debug.epl.path_mapping.gif"));
        this.mapPaths.setToolTipText(PHPServerUIMessages.getString("ServerTab.mapPaths"));
        this.mapPaths.addSelectionListener((SelectionListener)this.fListener);
        gd = this.mapPaths.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = -1;
        }
        this.validateDebuggerBtn = this.createPushButton(phpServerComp, null, ServersPluginImages.get("com.aptana.php.debug.epl.debugger_test.gif"));
        this.validateDebuggerBtn.setToolTipText(PHPServerUIMessages.getString("ServerTab.debuggerTest"));
        gd = this.validateDebuggerBtn.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = -1;
        }
        this.validateDebuggerBtn.addSelectionListener((SelectionListener)this.fListener);
        this.servers = PHPServersManager.getServers();
        if (!this.servers.isEmpty()) {
            int i = 0;
            while (i < this.servers.size()) {
                IServer svr = this.servers.get(i);
                this.serverCombo.add(svr.getName());
                ++i;
            }
        }
        if (this.serverCombo.getItemCount() > 0) {
            this.serverCombo.select(0);
            this.configureServers.setEnabled(true);
            this.mapPaths.setEnabled(true);
        } else {
            this.configureServers.setEnabled(false);
            this.mapPaths.setEnabled(false);
        }
        this.fillDebuggers();
        this.serverCombo.forceFocus();
    }

    private void updateDebugServerTesters() {
        int selectedDebuggerIndex = this.fDebuggersCombo.getSelectionIndex();
        String currentDebuggerType = this.fDebuggersCombo.getItem(selectedDebuggerIndex);
        this.debugTesters = this.retrieveAllServerTestExtensions(currentDebuggerType);
        if (this.debugTesters.length == 0) {
            this.validateDebuggerBtn.setEnabled(false);
        } else {
            this.validateDebuggerBtn.setEnabled(true);
        }
    }

    private IDebugServerConnectionTest[] retrieveAllServerTestExtensions(String currentDebuggerType) {
        String debugServerTestExtensionName = "com.aptana.php.debug.epl.debugServerConnectionTest";
        HashMap<String, IDebugServerConnectionTest> filtersMap = new HashMap<String, IDebugServerConnectionTest>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(debugServerTestExtensionName);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("debugServerTest".equals(element.getName())) {
                String id;
                new ElementCreationProxy(element, debugServerTestExtensionName);
                String debuggerTypeName = elements[i].getAttribute("debuggerTypeName");
                String overridesIds = elements[i].getAttribute("overridesId");
                if (debuggerTypeName.equals(currentDebuggerType) && !filtersMap.containsKey(id = element.getAttribute("id"))) {
                    if (overridesIds != null) {
                        StringTokenizer st = new StringTokenizer(overridesIds, ", ");
                        while (st.hasMoreTokens()) {
                            filtersMap.put(st.nextToken(), null);
                        }
                    }
                    try {
                        filtersMap.put(id, (IDebugServerConnectionTest)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        PHPDebugEPLPlugin.logError(e);
                    }
                }
            }
            ++i;
        }
        Collection l = filtersMap.values();
        while (l.remove(null)) {
        }
        this.debugTesters = l.toArray(new IDebugServerConnectionTest[l.size()]);
        return this.debugTesters;
    }

    protected void fillDebuggers() {
        this.fDebuggerIds = PHPDebuggersRegistry.getDebuggersIds();
        for (String id : this.fDebuggerIds) {
            this.fDebuggersCombo.add(PHPDebuggersRegistry.getDebuggerName(id));
        }
        String defaultName = PHPDebuggersRegistry.getDebuggerName(PHPDebuggersRegistry.getDefaultDebuggerId());
        int index = this.fDebuggersCombo.indexOf(defaultName);
        if (index > -1) {
            this.fDebuggersCombo.select(index);
        } else if (this.fDebuggersCombo.getItemCount() > 0) {
            this.fDebuggersCombo.select(0);
        }
    }

    public void createServerControl(Composite parent) {
        this.createServerSelectionControl(parent);
        GridData data = new GridData(256);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        this.handleServerSelection();
    }

    protected void createFileComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String projectLabel = PHPServerUIMessages.getString("ServerTab.file_project");
        group.setText(projectLabel);
        GridLayout layout = new GridLayout(3, false);
        GridData gd = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setFont(parent.getFont());
        Label label = new Label((Composite)group, 0);
        label.setText("Initial Script: ");
        this.fFile = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fFile.setLayoutData((Object)gd);
        this.fFile.addModifyListener((ModifyListener)this.fListener);
        this.fileButton = this.createPushButton((Composite)group, PHPServerUIMessages.getString("ServerTab.browse"), null);
        gd = (GridData)this.fileButton.getLayoutData();
        gd.horizontalSpan = 1;
        this.fileButton.addSelectionListener((SelectionListener)this.fListener);
        this.handleServerSelection();
    }

    public String[] getRequiredNatures() {
        return null;
    }

    protected void handleServerButtonSelected() {
        final IServer newServer = this.getServerFromWizard();
        if (newServer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ServerLaunchConfigurationTab.this.serverCombo.add(newServer.getName());
                    ServerLaunchConfigurationTab.this.serverCombo.select(ServerLaunchConfigurationTab.this.serverCombo.indexOf(newServer.getName()));
                    ServerLaunchConfigurationTab.this.handleServerSelection();
                    ServerLaunchConfigurationTab.this.configureServers.setEnabled(true);
                    ServerLaunchConfigurationTab.this.mapPaths.setEnabled(true);
                }
            });
        }
    }

    protected void handleConfigureButtonSelected() {
        int selectionIndex = this.serverCombo.getSelectionIndex();
        IServer server = this.servers.get(selectionIndex);
        String serverName = server.getName();
        try {
            Dialog dlg = PropertyDialogsRegistry.getInstance().createPropertyDialog((Object)server, (IShellProvider)new SameShellProvider((Control)UIUtils.getActiveShell()));
            if (dlg != null) {
                if (dlg instanceof IPropertyDialog) {
                    ((IPropertyDialog)dlg).setPropertySource((Object)server);
                }
                if (dlg.open() == 0) {
                    String newName = server.getName();
                    if (!newName.equals(serverName)) {
                        this.serverCombo.remove(selectionIndex);
                        this.serverCombo.add(newName, selectionIndex);
                        this.serverCombo.select(selectionIndex);
                    }
                    this.saveWorkingCopy = true;
                    this.handleServerSelection();
                }
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PHPDebugEPLPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void handlePathMapping() {
        PathMapperDialog dialog = new PathMapperDialog(this.getShell(), this.server);
        if (dialog.open() == 0) {
            new PathMappingUpdater().updatePaths(this.server, new String[]{this.workingCopy.getName()});
            this.initializeFrom(this.workingCopy);
        }
    }

    protected void handleDebuggerValidation() {
        this.updateDebugServerTesters();
        int selectedServerIndex = this.serverCombo.getSelectionIndex();
        IServer server = this.servers.get(selectedServerIndex);
        Shell shell = this.getShell();
        IDebugServerConnectionTest[] iDebugServerConnectionTestArray = this.debugTesters;
        int n = this.debugTesters.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugServerConnectionTest debugServerTester = iDebugServerConnectionTestArray[n2];
            debugServerTester.testConnection(server, shell);
            ++n2;
        }
    }

    public String[] getFileExtensions() {
        return null;
    }

    private IResource getFileFromDialog(IProject project) {
        return LaunchUtilities.getFileFromDialog(project, this.getShell(), this.getFileExtensions(), this.getRequiredNatures(), false);
    }

    protected void handleFileButtonSelected() {
        IResource file = null;
        file = this.getFileFromDialog(null);
        if (file == null) {
            return;
        }
        String fName = file.getFullPath().toString();
        this.fFile.setText(fName);
    }

    protected void updateURLComponents(String urlStr) {
        try {
            if (urlStr != null && urlStr.length() > 0) {
                URL url = new URL(urlStr);
                String port = url.getPort() == -1 || url.getPort() == 80 ? "" : ":" + url.getPort();
                this.fURLHost.setText(String.valueOf(url.getProtocol()) + "://" + url.getHost() + port + "/");
                if (url.getQuery() != null) {
                    this.fURLPath.setText(String.valueOf(url.getPath()) + "?" + url.getQuery());
                } else {
                    this.fURLPath.setText(url.getPath());
                }
            }
        }
        catch (MalformedURLException e) {
            PHPDebugEPLPlugin.logError(e);
        }
    }

    protected IProject getProject(String name) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        if (projects == null || projects.length == 0) {
            return null;
        }
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getName().equals(name)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    protected void handleServerSelection() {
        IServer obj;
        int numEntries = this.serverCombo.getItemCount();
        int index = this.serverCombo.getSelectionIndex();
        if (!this.servers.isEmpty() && (obj = this.servers.get(this.serverCombo.getSelectionIndex())) != null && obj instanceof IServer) {
            this.server = this.servers.get(this.serverCombo.getSelectionIndex());
            this.initializeURLControl();
        }
        if (this.server == null && index + 1 != numEntries) {
            this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.noSelectedServerError"));
        } else {
            this.setErrorMessage(null);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.setErrorMessage(null);
        try {
            this.selectDefaultServer((ILaunchConfiguration)configuration);
            this.selectDefaultDebugger((ILaunchConfiguration)configuration);
        }
        catch (CoreException e) {
            PHPDebugEPLPlugin.logError(e);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.workingCopy = configuration;
        this.serverCombo.setEnabled(true);
        this.setErrorMessage(null);
        try {
            String fileName = configuration.getAttribute("ATTR_SERVER_FILE_NAME", "");
            String url = configuration.getAttribute("ATTR_SERVER_BASE_URL", "");
            boolean isAutoGeneratedURL = configuration.getAttribute("ATTR_AUTO_GENERATED_URL", true);
            try {
                boolean attribute = configuration.getAttribute("ATTR_USE_SPECIFIC_FILE", true);
                this.fFile.setEnabled(attribute);
                this.fileButton.setEnabled(attribute);
            }
            catch (CoreException e1) {
                PHPDebugEPLPlugin.logError("Error initializing the Server launch configuration tab", e1);
            }
            this.initializeDebuggerControl(configuration);
            this.initializeServerControl(configuration);
            if (isAutoGeneratedURL) {
                this.autoGeneratedURL.setSelection(true);
                String computedURL = this.computeURL(this.formatFileName(fileName));
                this.fURLLabel.setEnabled(false);
                this.updateURLComponents(computedURL);
                this.fURLPath.setEnabled(false);
            } else {
                this.autoGeneratedURL.setSelection(false);
                this.fURLLabel.setEnabled(true);
                this.updateURLComponents(url);
                this.fURLPath.setEnabled(true);
                this.pathMapperNotification.setVisible(false);
            }
            this.fFile.setText(fileName);
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setSelection(configuration.getAttribute("firstLineBreakpoint", PHPDebugEPLPlugin.getStopAtFirstLine()));
            }
        }
        catch (CoreException coreException) {}
        this.initializeExtensionControls(configuration);
        this.isValid(configuration);
    }

    protected void initializeExtensionControls(ILaunchConfiguration configuration) {
    }

    protected String computeURL(String fileName) {
        if (this.server == null) {
            return "";
        }
        String urlString = this.server.getBaseURL().toString();
        if (urlString.equals("")) {
            urlString = "http://localhost";
        }
        StringBuffer url = new StringBuffer(urlString);
        boolean displayMapperNotification = false;
        if (!fileName.equals("")) {
            PathMapper pathMapper;
            String remoteFile;
            if (this.autoGeneratedURL.getSelection() && this.server != null && (remoteFile = (pathMapper = PathMapperRegistry.getByServer(this.server)).getRemoteFile(fileName)) != null && !"".equals(remoteFile) && !remoteFile.equals(fileName)) {
                displayMapperNotification = true;
                if (new File(remoteFile).exists()) {
                    this.pathMapperNotification.setText(PHPServerUIMessages.getString("ServerTab.autoGeneratedConflictMapper"));
                    this.pathMapperNotification.setToolTipText("The mapped path for '" + url.toString() + fileName + "' \nis mapped to: \n" + remoteFile);
                } else {
                    this.pathMapperNotification.setText(PHPServerUIMessages.getString("ServerTab.mapperHasMappingMessage"));
                    this.pathMapperNotification.setToolTipText("The target path has a mapping from: \n" + url.toString() + fileName + " \n  To: \n" + url.toString() + remoteFile);
                }
            }
            url.append(fileName);
        }
        this.pathMapperNotification.setVisible(displayMapperNotification);
        return url.toString();
    }

    private String formatFileName(String fileName) {
        String formatFile = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(fileName);
        if (resource == null) {
            return fileName;
        }
        int type = resource.getType();
        formatFile = type == 1 || type == 2 ? resource.getFullPath().toString() : "/";
        if (!formatFile.startsWith("/")) {
            formatFile = "/" + formatFile;
        }
        return formatFile;
    }

    protected String getDefaultExtension() {
        return null;
    }

    protected void initializeURLControl() {
        String file;
        if (this.fFile == null || this.fURLPath == null || this.fURLHost == null) {
            return;
        }
        if (this.autoGeneratedURL.getSelection()) {
            file = this.formatFileName(this.fFile.getText());
        } else {
            file = this.fURLPath.getText();
            this.pathMapperNotification.setVisible(false);
        }
        this.updateURLComponents(this.computeURL(file));
    }

    protected void initializeServerControl(ILaunchConfiguration configuration) {
        try {
            String serverName = configuration.getAttribute("ATTR_SERVER_NAME", "");
            if (serverName != null && !serverName.equals("")) {
                this.server = PHPServersManager.getServer((String)serverName);
                if (this.server == null) {
                    this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.invalidServerError"));
                    this.selectDefaultServer(configuration);
                } else {
                    this.serverCombo.setText(this.server.getName());
                }
            } else {
                this.selectDefaultServer(configuration);
            }
            if (configuration.getAttribute(READ_ONLY, false)) {
                this.serverCombo.setEnabled(false);
            }
        }
        catch (Exception exception) {}
    }

    protected void initializeDebuggerControl(ILaunchConfiguration configuration) {
        try {
            String debuggerID = configuration.getAttribute("com.aptana.php.debug.php_debugger_id", "");
            if (debuggerID != null && !debuggerID.equals("")) {
                this.fDebuggersCombo.setText(PHPDebuggersRegistry.getDebuggerName(debuggerID));
            } else {
                this.selectDefaultDebugger(configuration);
            }
            if (configuration.getAttribute(READ_ONLY, false)) {
                this.fDebuggersCombo.setEnabled(false);
            }
        }
        catch (Exception exception) {}
    }

    private void selectDefaultServer(ILaunchConfiguration configuration) throws CoreException {
        if (this.serverCombo != null && this.serverCombo.getItemCount() > 0) {
            IServer defaultServer;
            int nameIndex;
            String projectName = configuration.getAttribute("org2.eclipse.php.debug.core.PHP_Project", null);
            IProject project = null;
            if (projectName != null) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            if ((nameIndex = this.serverCombo.indexOf((defaultServer = PHPServersManager.getDefaultServer(project)).getName())) > -1) {
                this.serverCombo.select(nameIndex);
            } else {
                this.serverCombo.select(0);
            }
            this.server = PHPServersManager.getServer((String)this.serverCombo.getText());
        }
    }

    private void selectDefaultDebugger(ILaunchConfiguration configuration) throws CoreException {
        if (this.fDebuggersCombo != null && this.fDebuggersCombo.getItemCount() > 0) {
            String defaultDebuggerID;
            String debuggerName;
            int nameIndex;
            String projectName = configuration.getAttribute("org2.eclipse.php.debug.core.PHP_Project", null);
            IProject project = null;
            if (projectName != null) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
            if ((nameIndex = this.fDebuggersCombo.indexOf(debuggerName = PHPDebuggersRegistry.getDebuggerName(defaultDebuggerID = PHPProjectPreferences.getDefaultDebuggerID(project)))) > -1) {
                this.fDebuggersCombo.select(nameIndex);
            } else {
                this.fDebuggersCombo.select(0);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.aptana.php.debug.php_debugger_id", this.getSelectedDebuggerId());
        if (this.server != null) {
            configuration.setAttribute("ATTR_SERVER_NAME", this.server.getName());
        } else {
            configuration.setAttribute("ATTR_SERVER_NAME", null);
        }
        String fileName = this.fFile.getText();
        String urlPath = this.fURLPath.getText().replace('\\', '/');
        if (urlPath.startsWith("/")) {
            urlPath = urlPath.substring(1);
        }
        String url = String.valueOf(this.fURLHost.getText()) + urlPath;
        configuration.setAttribute("ATTR_SERVER_FILE_NAME", fileName);
        configuration.setAttribute("ATTR_SERVER_BASE_URL", url);
        configuration.setAttribute("ATTR_AUTO_GENERATED_URL", this.autoGeneratedURL.getSelection());
        configuration.setAttribute("firstLineBreakpoint", this.breakOnFirstLine.getSelection());
        configuration.setAttribute("ATTR_USE_SPECIFIC_FILE", true);
        boolean autoGenerateURL = this.autoGeneratedURL.getSelection();
        this.fURLLabel.setEnabled(!autoGenerateURL);
        this.fURLPath.setEnabled(!autoGenerateURL);
        this.applyExtension(configuration);
        if (this.saveWorkingCopy) {
            try {
                configuration.doSave();
            }
            catch (CoreException coreException) {}
            this.saveWorkingCopy = false;
        }
        this.applyLaunchDelegateConfiguration(configuration);
    }

    protected void applyLaunchDelegateConfiguration(ILaunchConfigurationWorkingCopy configuration) {
        String debuggerID = null;
        try {
            debuggerID = configuration.getAttribute("com.aptana.php.debug.php_debugger_id", PHPDebugEPLPlugin.getCurrentDebuggerId());
            AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration(debuggerID);
            configuration.setAttribute("com.aptana.php.debug.configurationDelegateClass", debuggerConfiguration.getWebLaunchDelegateClass());
        }
        catch (Exception e) {
            PHPDebugEPLPlugin.logError(e);
        }
        this.updateDebugServerTesters();
    }

    protected void createBreakControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Breakpoint");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.breakOnFirstLine = this.createCheckButton((Composite)group, "Break at First Line");
        this.breakOnFirstLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerLaunchConfigurationTab.this.setDirty(true);
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        String mode = this.getLaunchConfigurationDialog().getMode();
        boolean isDebugMode = "debug".equals(mode);
        this.breakOnFirstLine.setEnabled(isDebugMode);
    }

    protected void applyExtension(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        block11: {
            block10: {
                this.setMessage(null);
                this.setErrorMessage(null);
                try {
                    String serverName = launchConfig.getAttribute("ATTR_SERVER_NAME", "");
                    if (serverName.equals("")) break block10;
                    IServer server = PHPServersManager.getServer((String)serverName);
                    if (server == null) {
                        ILaunchConfiguration[] allConfigurations;
                        this.deleteLaunchConfiguration(launchConfig);
                        ILaunchConfiguration[] iLaunchConfigurationArray = allConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                        int n = allConfigurations.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILaunchConfiguration element = iLaunchConfigurationArray[n2];
                            launchConfig = element;
                            serverName = launchConfig.getAttribute("ATTR_SERVER_NAME", "");
                            if (!serverName.equals("") && PHPServersManager.getServer((String)serverName) == null) {
                                this.deleteLaunchConfiguration(launchConfig);
                            }
                            ++n2;
                        }
                        this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.missingServer"));
                        return false;
                    }
                    break block11;
                }
                catch (CoreException coreException) {}
            }
            this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.missingServer"));
            return false;
        }
        String fileName = launchConfig.getAttribute("ATTR_SERVER_FILE_NAME", "");
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(fileName);
        if (!(resource instanceof IFile)) {
            if (fileName.trim().length() == 0) {
                this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.specifyInitialScript"));
            } else {
                this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.file_project_doesNotExist"));
            }
            return false;
        }
        return this.isValidExtension(launchConfig);
    }

    private void deleteLaunchConfiguration(final ILaunchConfiguration launchConfig) throws CoreException {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ILaunchConfiguration config = launchConfig;
                try {
                    if (config instanceof ILaunchConfigurationWorkingCopy) {
                        config = ((ILaunchConfigurationWorkingCopy)config).getOriginal();
                    }
                    if (config != null) {
                        config.delete();
                    }
                }
                catch (CoreException coreException) {}
            }
        });
    }

    protected boolean isValidExtension(ILaunchConfiguration launchConfig) {
        return true;
    }

    public Image getImage() {
        return null;
    }

    public String getName() {
        return PHPServerUIMessages.getString("ServerTab.server");
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuffer stripped = new StringBuffer();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            stripped.append(element);
            ++n2;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    private String getSelectedDebuggerId() {
        int selectedIndex = this.fDebuggersCombo.getSelectionIndex();
        String debuggerId = "org2.eclipse.php.debug.core.zendDebugger";
        if (selectedIndex > -1 && this.fDebuggerIds.size() > selectedIndex) {
            debuggerId = this.fDebuggerIds.toArray()[selectedIndex].toString();
        }
        return debuggerId;
    }

    protected IServer getServerFromWizard() {
        try {
            Dialog dlg;
            IServer newServer = WebServerCorePlugin.getDefault().getServerManager().createServer("com.aptana.webserver.external");
            if (newServer != null && (dlg = new ExternalWebServerPropertyDialog.Provider().createPropertyDialog((IShellProvider)new SameShellProvider((Control)this.getShell()))) != null) {
                if (dlg instanceof IPropertyDialog) {
                    ((IPropertyDialog)dlg).setPropertySource((Object)newServer);
                }
                if (dlg.open() == 0) {
                    WebServerCorePlugin.getDefault().getServerManager().add(newServer);
                    return newServer;
                }
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PHPDebugEPLPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            ServerLaunchConfigurationTab.this.initializeURLControl();
        }

        public void widgetSelected(SelectionEvent e) {
            ServerLaunchConfigurationTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == ServerLaunchConfigurationTab.this.fileButton) {
                ServerLaunchConfigurationTab.this.handleFileButtonSelected();
            } else if (source == ServerLaunchConfigurationTab.this.createNewServer) {
                ServerLaunchConfigurationTab.this.handleServerButtonSelected();
            } else if (source == ServerLaunchConfigurationTab.this.configureServers) {
                ServerLaunchConfigurationTab.this.handleConfigureButtonSelected();
            } else if (source == ServerLaunchConfigurationTab.this.mapPaths) {
                ServerLaunchConfigurationTab.this.handlePathMapping();
            } else if (source == ServerLaunchConfigurationTab.this.validateDebuggerBtn) {
                ServerLaunchConfigurationTab.this.handleDebuggerValidation();
            }
        }
    }
}

